using System;
using System.Linq;

class Program
{
    static (int, int[]) FindMaximumXor(int[] P)
    {
        int xorSum = 0;
        int[] Q = new int[P.Length];

        for (int i = 31; i >= 0; i--)
        {
            int countSet = P.Count(x => (x >> i & 1) == 1);

            if (countSet <= P.Length / 2)
            {
                xorSum += countSet * (1 << i);
                for (int j = 0; j < P.Length; j++)
                {
                    if ((P[j] >> i & 1) == 1)
                        Q[j] |= 1 << i;
                }
            }
            else
            {
                xorSum += (P.Length - countSet) * (1 << i);
                for (int j = 0; j < P.Length; j++)
                {
                    if ((P[j] >> i & 1) == 0)
                        Q[j] |= 1 << i;
                }
            }
        }

        return (xorSum, Q);
    }

    static void Main()
    {
        int T = int.Parse(Console.ReadLine());

        for (int t = 0; t < T; t++)
        {
            int N = int.Parse(Console.ReadLine());
            int[] P = Console.ReadLine().Split().Select(int.Parse).ToArray();

            var result = FindMaximumXor(P);
            Console.WriteLine(result.Item1);
            Console.WriteLine(string.Join(" ", result.Item2));
        }
    }
}